<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Shared;

use PhpOption\Option;

/**
 * Trait FieldContainer.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
trait FieldContainer
{
    /**
     * @internal
     *
     * @var Field[]
     */
    private $fields = [];

    /**
     * @return Field[]
     */
    public function getFields(): array
    {
        return $this->fields;
    }

    /**
     * @param string $name
     *
     * @return Option may contain a subtype of @see Field
     */
    public function getField(string $name): Option
    {
        return Option::fromValue(
            \Functional\first($this->fields, function (Field $field) use ($name) {
                return $field->getName() === $name;
            })
        );
    }

    /**
     * @param string $name
     *
     * @return Option may contain the value of a single field
     */
    public function getSingleFieldValue(string $name): Option
    {
        return $this->getField($name)->map(
            function (SingleField $field) {
                return $field->getValue();
            }
        );
    }

    /**
     * @param Field[] $fields
     */
    private function setFields($fields)
    {
        $this->fields = $fields;
    }
}
