<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Repository;

use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\Criteria;
use Doctrine\ORM\EntityRepository;
use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;
use IssetBV\PaymentBundle\Domain\Subscription\Repository\SubscriptionRepository;
use IssetBV\PaymentBundle\Domain\Subscription\Subscription;
use IssetBV\PaymentBundle\Domain\Subscription\SubscriptionIdentifier;
use PhpOption\Option;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class DoctrineSubscriptionRepository extends EntityRepository implements SubscriptionRepository
{
    /**
     * @return Collection|Subscription[]
     */
    public function findAll()
    {
        return $this->matching(Criteria::create());
    }

    public function optionallyFind(SubscriptionIdentifier $identifier): Option
    {
        return Option::ensure(parent::find($identifier->asString()));
    }

    public function findByPayment(LocalPaymentIdentifier $paymentIdentifier): Option
    {
        $qb = $this->createQueryBuilder('subscription');
        $qb->join('subscription.subscriptionTerms', 'term');
        $qb->join('term.payment', 'payment');
        $qb->where($qb->expr()->eq('payment', ':payment'));
        $qb->setParameter('payment', $paymentIdentifier->asString());

        return Option::ensure($qb->getQuery()->getOneOrNullResult());
    }
}
