<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\CreateSubscription;

use DateInterval;
use DateTime;
use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;
use PhpOption\Option;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class CreateSubscriptionCommand
{
    /**
     * @var string
     */
    private $initialInterval;

    /**
     * @var LocalPaymentIdentifier
     */
    private $paymentIdentifier;

    /**
     * @var DateTime
     */
    private $startDate;

    /**
     * @var string
     */
    private $subscriptionInterval;

    public function __construct(LocalPaymentIdentifier $paymentIdentifier, string $subscriptionInterval = '1 month', string $initialInterval = '1 month', DateTime $startDate)
    {
        $this->paymentIdentifier = $paymentIdentifier;
        $this->subscriptionInterval = $subscriptionInterval;
        $this->initialInterval = $initialInterval;
        $this->startDate = $startDate;
    }

    public function getInitialDateInterval(): Option
    {
        return Option::ensure(DateInterval::createFromDateString($this->initialInterval));
    }

    public function getOriginalPaymentIdentifier(): LocalPaymentIdentifier
    {
        return $this->paymentIdentifier;
    }

    public function getSubscriptionInterval(): DateInterval
    {
        return DateInterval::createFromDateString($this->subscriptionInterval);
    }

    public function getSubscriptionStartDate(): DateTime
    {
        return $this->startDate;
    }
}
