<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\PaymentBundle\Domain\Mutation;
use IssetBV\PaymentBundle\Domain\Repository\MutationRepository;
use PhpOption\Option;

/**
 * Class TalosMutationRepository.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class DoctrineMutationRepository extends EntityRepository implements MutationRepository
{
    /**
     * @param string $mutationIdentifier hexadecimal string representation of the remote identifier of the
     *
     * @return Mutation|Option <Mutation> and optional containing the mutation
     */
    public function findWithRemoteIdentifier(string $mutationIdentifier): Option
    {
        return Option::ensure($this->find($mutationIdentifier));
    }

    /**
     * @param Mutation $mutation
     */
    public function save(Mutation $mutation)
    {
        $this->getEntityManager()->persist($mutation);
    }
}
