<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Response\Handler;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use IssetBV\TalosBundle\Gateway\Response\Response;

/**
 * Trait ResponseHandlerContainer.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
trait RequestResultHandlerAware
{
    /**
     * @var ResponseHandler[]|Collection|null
     */
    private $responseHandlers;

    /**
     * @var RequestErrorHandler[]|Collection|null
     */
    private $requestErrorHandlers;

    /**
     * @param ResponseHandler $responseHandler
     */
    public function addResponseHandler(ResponseHandler $responseHandler)
    {
        $this->getResponseHandlers()->add($responseHandler);
    }

    /**
     * @param Response $response
     */
    public function callResponseHandlers(Response $response)
    {
        foreach ($this->getResponseHandlers() as $responseHandler) {
            $responseHandler->handleResponse($response);
        }
    }

    /**
     * @param array $options
     */
    public function callRequestErrorHandlers(array $options)
    {
        foreach ($this->getRequestErrorHandlers() as $requestErrorHandler) {
            $requestErrorHandler->onError($options);
        }
    }

    /**
     * @param RequestErrorHandler $requestErrorHandler
     */
    public function addRequestErrorHandler(RequestErrorHandler $requestErrorHandler)
    {
        $this->getRequestErrorHandlers()->add($requestErrorHandler);
    }

    /**
     * @return ArrayCollection
     */
    private function getResponseHandlers()
    {
        $this->responseHandlers = $this->responseHandlers ?: new ArrayCollection();

        return $this->responseHandlers;
    }

    /**
     * @return ArrayCollection
     */
    private function getRequestErrorHandlers()
    {
        $this->requestErrorHandlers = $this->requestErrorHandlers ?: new ArrayCollection();

        return $this->requestErrorHandlers;
    }
}
