<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Cli;

use IssetBV\PaymentBundle\CommandBus\SynchronizeWallet\SynchronizeWalletCommand as SynchronizeWalletCommandBusCommand;
use League\Tactician\CommandBus;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class SynchronizeWalletCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 *
 * @todo move to Cli namespace and change to service
 */
class SynchronizeWalletCommand extends Command
{
    /**
     * @var CommandBus
     */
    private $commandBus;

    /**
     * SynchronizeWalletCommand constructor.
     *
     * @param CommandBus $commandBus
     */
    public function __construct(CommandBus $commandBus)
    {
        parent::__construct('talos:wallet:sync');
        $this->commandBus = $commandBus;
    }

    protected function configure()
    {
        $this->addArgument('wallet', InputArgument::REQUIRED, 'The primary identifier of the wallet');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int|null|void
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->commandBus->handle(new SynchronizeWalletCommandBusCommand($input->getArgument('wallet')));
    }
}
