<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\RemoveAutoRenew;

use IssetBV\TalosBundle\Gateway\Request\ClientData;
use PhpOption\Option;

/**
 * Class RemoveAutoRenewCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class RemoveAutoRenewCommand
{
    /**
     * @var ClientData
     */
    private $clientData;

    /**
     * @var string
     */
    private $walletIdentifier;

    /**
     * RemoveAutoRenewCommand constructor.
     *
     * @param string $walletIdentifier
     * @param ClientData $clientData
     */
    public function __construct(string $walletIdentifier, ClientData $clientData = null)
    {
        $this->walletIdentifier = $walletIdentifier;
        $this->clientData = $clientData;
    }

    /**
     * @return string
     */
    public function getWalletIdentifier(): string
    {
        return $this->walletIdentifier;
    }

    /**
     * @return Option
     */
    public function getClientData()
    {
        return Option::ensure($this->clientData);
    }
}
