<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Storage;

use Doctrine\Common\Persistence\ObjectManager;
use PhpOption\Option;

/**
 * Class Persister.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class DoctrineEntityStore implements EntityStore
{
    /**
     * @var Option
     */
    private $objectManager;

    /**
     * Persister constructor.
     *
     * @param ObjectManager|null $objectManager
     */
    public function __construct(ObjectManager $objectManager = null)
    {
        $this->objectManager = Option::ensure($objectManager);
    }

    public function persist($entity)
    {
        $this->objectManager
            ->getOrThrow(new StorageException('Cannot store %s because the entity manager was not configured'))
            ->persist($entity);
    }
}
