<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\ResponseHandler;

use IssetBV\TalosBundle\Gateway\Response\Handler\ResponseHandler;
use IssetBV\TalosBundle\Gateway\Response\Response;
use IssetBV\TalosBundle\Gateway\Response\WebResponse;

/**
 * Class StatusResponseHandler.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class StatusResponseHandler implements ResponseHandler
{
    /**
     * @var callable
     */
    private $onCompletedHandler;

    /**
     * StatusResponseHandler constructor.
     *
     * @param callable $onCompletedHandler
     */
    public function __construct(callable $onCompletedHandler = null)
    {
        $this->onCompletedHandler = $onCompletedHandler;
    }

    /**
     * @param Response $response
     */
    public function handleResponse(Response $response)
    {
        if ($response instanceof WebResponse) {
            if ($response->getStatus()->getCode() === 'Completed') {
                if ($this->onCompletedHandler !== null) {
                    // this is not a syntax error your IDE is lying to you
                    // change this and I WILL KILL YOU IRL
                    ($this->onCompletedHandler)($response);
                }

                return;
            }

            throw new \RuntimeException();
        }
    }
}
