<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain\Repository;

use Money\Money;
use PhpOption\Option;

/**
 * Interface AutoTopupProfileRepository.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface AutoTopupProfileRepository
{
    /**
     * @param int $cooldown
     * @param Money $activationBalance
     *
     * @return Option
     */
    public function findOneByCooldownAndActivationBalance($cooldown, $activationBalance): Option;

    /**
     * @param string $autoTopupProfileKey
     *
     * @return Option
     */
    public function optionallyFind(string $autoTopupProfileKey): Option;
}
