<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\ResponseHandler;

use IssetBV\TalosBundle\Gateway\Response\Handler\RequestErrorHandler;
use IssetBV\TalosBundle\Gateway\Response\Handler\ResponseHandler;
use IssetBV\TalosBundle\Gateway\Response\Response;

/**
 * Class DumpingResponseHandler.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class DumpingResponseHandler implements ResponseHandler, RequestErrorHandler
{
    /**
     * @param Response $response
     */
    public function handleResponse(Response $response)
    {
        dump($response);
    }

    /**
     * @param array $options
     */
    public function onError(array $options)
    {
        if (array_key_exists('exception', $options)) {
            dump(get_class($options['exception']));
            dump($options['exception']->getMessage());
        }

        dump($options['response']);

        throw $options['exception'];
    }
}
