<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Request;

use JsonSerializable;

/**
 * Class Batch.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class Batch implements JsonSerializable
{
    /**
     * @var string
     */
    private $channel;

    /**
     * @var Request[]
     */
    private $requests;

    /**
     * @var string
     */
    private $senderCode;

    /**
     * Batch constructor.
     *
     * @param string $senderCode
     * @param Request[] $requests
     * @param string $channel
     */
    public function __construct(string $senderCode, array $requests, string $channel)
    {
        $this->senderCode = $senderCode;
        $this->requests = $requests;
        $this->channel = $channel;
    }

    /**
     * @deprecated
     *
     * @return array
     */
    public function toSerializable()
    {
        return $this->jsonSerialize();
    }

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'SenderCode' => $this->senderCode,
            'Channel' => $this->channel,
            'Requests' => $this->requests,
        ];
    }
}
