<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Factory;

use IssetBV\PaymentBundle\Domain\Invoice\Invoice;
use IssetBV\PaymentBundle\Domain\Invoice\InvoiceNumber;

/**
 * Interface InvoiceFactory.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface InvoiceFactory
{
    /**
     * @param InvoiceNumber|null $invoiceNumber If this argument is NULL then the Factory has to generate new invoice number
     *
     * @return Invoice
     */
    public function createInvoice(InvoiceNumber $invoiceNumber = null): Invoice;
}
