<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\CreateSubscription;

use DateTime;
use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class CreateSubscriptionCommandFactory
{
    /**
     * @var string
     */
    private $initialInterval;

    /**
     * @var LocalPaymentIdentifier
     */
    private $paymentIdentifier;

    /**
     * @var DateTime
     */
    private $startDate = null;

    /**
     * @var string
     */
    private $subscriptionInterval;

    private function __construct(LocalPaymentIdentifier $paymentIdentifier, string $subscriptionInterval)
    {
        $this->paymentIdentifier = $paymentIdentifier;
        $this->subscriptionInterval = $subscriptionInterval;
        $this->initialInterval = $subscriptionInterval;
    }

    public function withInitialInterval(string $initialInterval)
    {
        $this->initialInterval = $initialInterval;

        return $this;
    }

    public function withStartDate(DateTime $startDate)
    {
        $this->startDate = $startDate;

        return $this;
    }

    public static function createCommandFrom(LocalPaymentIdentifier $paymentIdentifier, string $subscriptionInterval)
    {
        return new self($paymentIdentifier, $subscriptionInterval);
    }

    public function get(): CreateSubscriptionCommand
    {
        return new CreateSubscriptionCommand($this->paymentIdentifier, $this->subscriptionInterval, $this->initialInterval, $this->startDate);
    }
}
