<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain\Identifier;

use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;

/**
 * Class UuidPaymentIdentifier.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class UuidPaymentIdentifier implements LocalPaymentIdentifier
{
    private $uuid;

    public function __construct(UuidInterface $uuid)
    {
        $this->uuid = $uuid;
    }

    public function __toString()
    {
        return (string) $this->uuid;
    }

    public function asString(): string
    {
        return (string) $this->uuid;
    }

    public static function fromString(string $string): LocalPaymentIdentifier
    {
        return new self(Uuid::fromString($string));
    }
}
