<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\CreateSubscription;

use Exception;
use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class CannotCreateSubscriptionException extends Exception
{
    public static function becauseTheOriginalPaymentCouldNoBeFound(LocalPaymentIdentifier $paymentIdentifier): CannotCreateSubscriptionException
    {
        return new self('Cannot create subscription because no payment with id ' . $paymentIdentifier->asString() . ' could be found');
    }
}
