<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;
use IssetBV\PaymentBundle\Domain\PaymentIssuer;
use IssetBV\PaymentBundle\Domain\PaymentMethod;
use IssetBV\PaymentBundle\Domain\Wallet;

/**
 * Class TalosPaymentMethod.
 *
 * @author Tim Fennis <tim@isset.nl>
 * @ORM\Entity(repositoryClass="IssetBV\TalosBundle\Repository\DoctrinePaymentMethodRepository")
 * @ORM\Table(name="talos__payment_methods")
 */
class TalosPaymentMethod implements PaymentMethod
{
    const SERVICE_NAME_IDEAL = 'iDEAL';
    const SERVICE_NAME_SEPA = 'SepaDirectDebit';

    /**
     * @var int
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     * @ORM\Column(name="display_name", type="string", nullable=false)
     */
    private $displayName;

    /**
     * @var PaymentIssuer[]
     * @ORM\OneToMany(targetEntity="IssetBV\PaymentBundle\Domain\PaymentIssuer", mappedBy="paymentMethod")
     */
    private $issuers;

    /**
     * @internal This is used to communicate with Talos
     *
     * @var string
     * @ORM\Column(name="service_name", type="string", nullable=false)
     */
    private $serviceName;

    /**
     * @var DateTime
     * @ORM\Column(name="date_active", type="datetime", nullable=true)
     */
    private $dateActive;

    /**
     * It's an explicit choice to use TalosWallet here instead of the Wallet interface. These two classes are tightly
     * coupled!
     *
     * @var TalosWallet
     * @ORM\ManyToOne(targetEntity="IssetBV\TalosBundle\Entity\TalosWallet")
     * @ORM\JoinColumn(name="wallet_id", referencedColumnName="id")
     */
    private $wallet;

    /**
     * TalosPaymentMethod constructor.
     */
    private function __construct()
    {
        // fuck off
    }

    /**
     * @return string
     */
    public function getDisplayName(): string
    {
        return $this->displayName;
    }

    /**
     * @return string
     */
    public function getServiceName(): string
    {
        return $this->serviceName;
    }

    /**
     * Returns a list of issuers associated to this payment method. Note that some payment methods don't have issuers.
     *
     * @return PaymentIssuer[]
     */
    public function getIssuers()
    {
        return $this->issuers;
    }

    /**
     * Because in rare cases a payment method may need an issuer can't provide any for technical reasons. This method
     * should be used to check if a payment method requires an issuer.
     *
     * @return bool
     */
    public function shouldHaveIssuers(): bool
    {
        // for now this implementation is fine
        return $this->serviceName === self::SERVICE_NAME_IDEAL;
    }

    /**
     * @return Wallet
     */
    public function getWallet(): Wallet
    {
        return $this->wallet;
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }
}
