<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain\Subscription;

use DateInterval;
use DateTime;
use IssetBV\PaymentBundle\Domain\Payment;
use PhpOption\Option;

/**
 * Interface Subscription.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface Subscription
{
    public function getId(): SubscriptionIdentifier;

    public function cancel(): bool;

    public function getDateValidUntil(): Option;

    public function getStartDate(): DateTime;

    public function getDateCanceled(): Option;

    public function getStatus(): SubscriptionStatus;

    public function getPaymentInterval(): DateInterval;

    public function getOriginalPayment(): Payment;

    public function isCanceled(): bool;
}
