<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\RenewSubscription;

use IssetBV\PaymentBundle\Domain\Subscription\SubscriptionIdentifier;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class RenewSubscriptionCommand
{
    /**
     * @var SubscriptionIdentifier
     */
    private $subscriptionIdentifier;

    /**
     * RenewSubscriptionCommand constructor.
     *
     * @param SubscriptionIdentifier $subscriptionIdentifier
     */
    public function __construct(SubscriptionIdentifier $subscriptionIdentifier)
    {
        $this->subscriptionIdentifier = $subscriptionIdentifier;
    }

    /**
     * @return SubscriptionIdentifier
     */
    public function getSubscriptionIdentifier(): SubscriptionIdentifier
    {
        return $this->subscriptionIdentifier;
    }
}
