<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\DenormalizeSubscriptionStatus;

use IssetBV\PaymentBundle\Domain\Subscription\SubscriptionIdentifier;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class DenormalizeSubscriptionStatusCommand
{
    /**
     * @var SubscriptionIdentifier
     */
    private $subscriptionIdentifier;

    public function __construct(SubscriptionIdentifier $subscriptionIdentifier)
    {
        $this->subscriptionIdentifier = $subscriptionIdentifier;
    }

    public function getSubscriptionIdentifier(): SubscriptionIdentifier
    {
        return $this->subscriptionIdentifier;
    }
}
