<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\CreateMutation;

use IssetBV\TalosBundle\Gateway\Request\ClientData;
use Money\Money;
use PhpOption\Option;

/**
 * Class CreateMutationCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class CreateMutationCommand
{
    /**
     * @var ClientData
     */
    private $clientData;

    /**
     * @var Money
     */
    private $amount;

    /**
     * @var string|null
     */
    private $description;

    /**
     * @var string
     */
    private $sourceWalletIdentifier;

    /**
     * @var string
     */
    private $destinationWalletIdentifier;

    /**
     * CreateMutationCommand constructor.
     *
     * @param string $sourceWallet
     * @param string $destinationWallet
     * @param Money $amount
     * @param ClientData $clientData
     */
    public function __construct(string $sourceWallet, string $destinationWallet, Money $amount, ClientData $clientData = null)
    {
        $this->sourceWalletIdentifier = $sourceWallet;
        $this->destinationWalletIdentifier = $destinationWallet;
        $this->amount = $amount;
        $this->clientData = $clientData;
    }

    /**
     * @param string $description
     */
    public function setDescription(string $description)
    {
        $this->description = $description;
    }

    /**
     * @return Money
     */
    public function getAmount(): Money
    {
        return $this->amount;
    }

    /**
     * @return Option
     */
    public function getDescription(): Option
    {
        return Option::ensure($this->description);
    }

    /**
     * @return string
     */
    public function getSourceWalletIdentifier(): string
    {
        return $this->sourceWalletIdentifier;
    }

    /**
     * @return string
     */
    public function getDestinationWalletIdentifier(): string
    {
        return $this->destinationWalletIdentifier;
    }

    /**
     * @return Option
     */
    public function getClientData(): Option
    {
        return Option::ensure($this->clientData);
    }
}
