<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\CommandBus\SynchronizeWalletMutations;

use IssetBV\PaymentBundle\CommandBus\SynchronizeMutation\SynchronizeWalletMutationsCommand;
use IssetBV\TalosBundle\Gateway\ApiGateway;
use IssetBV\TalosBundle\Gateway\Request\ClientData;
use IssetBV\TalosBundle\Gateway\Request\Request;
use IssetBV\TalosBundle\Gateway\Request\Service;
use IssetBV\TalosBundle\Gateway\Shared\SingleField;
use IssetBV\TalosBundle\ResponseHandler\MutationResponseHandler;

/**
 * Class TalosSynchronizeMutationsHandler.
 *
 * @todo should probably be renamed to Synchronize Wallet Mutations or become part of Synchronize Wallet
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class SynchronizeWalletMutationsHandler
{
    /**
     * @var ApiGateway
     */
    private $apiGateway;

    /**
     * @var MutationResponseHandler
     */
    private $mutationResponseHandler;

    /**
     * TalosSynchronizeMutationsHandler constructor.
     *
     * @param ApiGateway $apiGateway
     * @param MutationResponseHandler $mutationResponseHandler
     */
    public function __construct(ApiGateway $apiGateway, MutationResponseHandler $mutationResponseHandler)
    {
        $this->apiGateway = $apiGateway;
        $this->mutationResponseHandler = $mutationResponseHandler;
    }

    /**
     * @param SynchronizeWalletMutationsCommand $synchronizeMutationsCommand
     */
    public function handle(SynchronizeWalletMutationsCommand $synchronizeMutationsCommand)
    {
        $statusRequest = new Request(ClientData::empty(), [
            new Service('WalletSystem', 'Status', [
                new SingleField('ObjectType', 'WalletMutation'),
                new SingleField('WalletKey', $synchronizeMutationsCommand->getWalletIdentifier()),
            ]),
        ]);

        $statusRequest->addResponseHandler($this->mutationResponseHandler);
//        $statusRequest->addRequestErrorHandler($requestResultHandler);

        $this->apiGateway->send([$statusRequest]);
    }
}
