<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Cli;

use IssetBV\PaymentBundle\CommandBus\CreateMutation\CreateMutationCommand as CreateMutationCommandBusCommand;
use League\Tactician\CommandBus;
use Money\MoneyFormatter;
use Money\Parser\DecimalMoneyParser;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class TransferCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class CreateMutationCommand extends Command
{
    /**
     * @var CommandBus
     */
    private $commandBus;

    /**
     * @var MoneyFormatter
     */
    private $moneyFormatter;

    /**
     * @var DecimalMoneyParser
     */
    private $moneyParser;

    public function __construct(CommandBus $commandBus, DecimalMoneyParser $moneyParser, MoneyFormatter $moneyFormatter)
    {
        parent::__construct('talos:mutation:create');
        $this->commandBus = $commandBus;
        $this->moneyParser = $moneyParser;
        $this->moneyFormatter = $moneyFormatter;
    }

    protected function configure()
    {
        $this->addArgument('sourceWallet', InputArgument::REQUIRED);
        $this->addArgument('destinationWallet', InputArgument::REQUIRED);
        $this->addArgument('amount', InputArgument::REQUIRED);
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $money = $this->moneyParser->parse($input->getArgument('amount'), 'EUR');

        $output->writeln(sprintf(
            '<info>Transfering %s from %s to %s</info>',
                $this->moneyFormatter->format($money),
            $input->getArgument('sourceWallet'),
            $input->getArgument('destinationWallet'))
        );

        $this->commandBus->handle(new CreateMutationCommandBusCommand(
            $input->getArgument('sourceWallet'),
            $input->getArgument('destinationWallet'),
            $money
        ));
    }
}
