<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain\Payment\Event;

use Assert\Assertion;
use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;
use Symfony\Component\EventDispatcher\Event;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class PaymentStatusChangedEvent extends Event
{
    const NAME = 'payment.status.changed';

    /**
     * @var LocalPaymentIdentifier
     */
    private $paymentIdentifier;

    /**
     * @var string
     */
    private $newPaymentStatus;

    /**
     * @var string
     */
    private $originalPaymentStatus;

    public function __construct(LocalPaymentIdentifier $paymentIdentifier, string $originalPaymentStatus, string $newPaymentStatus)
    {
        Assertion::notEq($originalPaymentStatus, $newPaymentStatus, 'Failed asserting that originalPaymentStatus argument differs from newPaymentStatus argument');

        $this->paymentIdentifier = $paymentIdentifier;
        $this->originalPaymentStatus = $originalPaymentStatus;
        $this->newPaymentStatus = $newPaymentStatus;
    }

    public function getPaymentIdentifier(): LocalPaymentIdentifier
    {
        return $this->paymentIdentifier;
    }

    public function getNewPaymentStatus(): string
    {
        return $this->newPaymentStatus;
    }

    public function getOriginalPaymentStatus(): string
    {
        return $this->originalPaymentStatus;
    }

    public static function name()
    {
        return self::NAME;
    }
}
