<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain;

use PhpOption\Option;

/**
 * This interface describes a subset of Payments that can be executed by the gateway.
 *
 * Note that implementing this interface correctly does not necessarily mean that you Payment is always valid for execution.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface ExecutablePayment extends Payment
{
    /**
     * Returns an option baring the description of this payment if such a description is set on this object.
     *
     * @return Option
     */
    public function getDescription(): Option;

    /**
     * Returns an original payment this payment is linked to. Used in case of recurrent payments.
     *
     * @return Option
     */
    public function getOriginalPayment(): Option;

    /**
     * @param Payment $originalPayment
     */
    public function setOriginalPayment(Payment $originalPayment);

    /**
     * Set a description for this payment. This description will (in case of Talos) be sent to the gateway and show up
     * in the payment UI.
     *
     * @param string $description
     */
    public function setDescription(string $description);

//    /**
//     * Returns an option baring the return URL that the payment gateway will redirect to after the payment has been
//     * completed. In most cases executing a payment without a return URL will result in an error.
//     *
//     * @return Option
//     */
//    public function getReturnUrl(): Option;
//
//    /**
//     * Set a return URL for this payment. This URL will be returned to after the user has completed their payment.
//     *
//     * @param string $returnUrl
//     */
//    public function setReturnUrl(string $returnUrl);

    /**
     * Returns an option baring the URL where a user can complete this payment. This should be the result of executing
     * a payment.
     *
     * @return Option
     */
    public function getPaymentUrl(): Option;

    /**
     * This method is to be used by the PaymentHandler to inject the Payment URL received from the Gateway.
     *
     * @param string $paymentUrl
     */
    public function setPaymentUrl(string $paymentUrl);

    /**
     * This method is used by the PaymentHandler to inject the customer's account name received from the Gateway.
     *
     * @param string $accountName
     */
    public function setCustomerAccountName(string $accountName);

    /**
     * This method is used by the PaymentHandler to inject the customer's account identifier received from the Gateway.
     *
     * @param string $accountIdentifier
     */
    public function setCustomerAccountIdentifier(string $accountIdentifier);
}
