<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\CreateSubscription;

use Doctrine\Common\Persistence\ObjectManager;
use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;
use IssetBV\PaymentBundle\Domain\Payment;
use IssetBV\PaymentBundle\Domain\Repository\PaymentRepository;
use IssetBV\PaymentBundle\Entity\Subscription;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class CreateSubscriptionHandler
{
    /**
     * @var ObjectManager
     */
    private $objectManager;

    /**
     * @var PaymentRepository
     */
    private $paymentRepository;

    public function __construct(ObjectManager $objectManager, PaymentRepository $paymentRepository)
    {
        $this->objectManager = $objectManager;
        $this->paymentRepository = $paymentRepository;
    }

    public function handle(CreateSubscriptionCommand $command)
    {
        $subscription = new Subscription(
            $command->getSubscriptionInterval(),
            $command->getSubscriptionStartDate(),
            $this->findPayment($command->getOriginalPaymentIdentifier()),
            $command->getInitialDateInterval()->getOrElse(null)
        );

        $this->objectManager->persist($subscription);
    }

    private function findPayment(LocalPaymentIdentifier $paymentIdentifier): Payment
    {
        return $this->paymentRepository->optionallyFind($paymentIdentifier)
            ->getOrThrow(CannotCreateSubscriptionException::becauseTheOriginalPaymentCouldNoBeFound($paymentIdentifier));
    }
}
