<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\PaymentBundle\Domain\Repository\PaymentMethodRepository;
use PhpOption\Option;

/**
 * Class DoctrinePaymentMethodRepository.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class DoctrinePaymentMethodRepository extends EntityRepository implements PaymentMethodRepository
{
    /**
     * @param string $serviceName
     *
     * @return Option
     */
    public function findByServiceName(string $serviceName): Option
    {
        return Option::ensure($this->findOneBy([
            'serviceName' => $serviceName
        ]));
    }
}
