<?php

declare(strict_types = 1);

namespace IssetBV\TalosBundle\Gateway\Logger;

use function Functional\each;

/**
 * Class LoggerChain.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class LoggerChain implements GatewayLogger
{
    /**
     * @var GatewayLogger[]
     */
    private $responseLoggers = [];

    /**
     * @param GatewayLogger $responseLogger
     */
    public function addGatewayLogger(GatewayLogger $responseLogger)
    {
        $this->responseLoggers[] = $responseLogger;
    }

    /**
     * @param LogData $logData
     */
    public function log(LogData $logData)
    {
        each($this->responseLoggers, function (GatewayLogger $responseLogger) use ($logData) {
            $responseLogger->log($logData);
        });
    }
}
