<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use IssetBV\PaymentBundle\Domain\Wallet;
use IssetBV\PaymentBundle\Domain\WalletOwner;

/**
 * @author Tim Fennis <tim@isset.nl>
 * @ORM\Entity()
 * @ORM\Table(name="talos__wallet_ownerships")
 */
class TalosWalletOwnership
{
    /**
     * @var WalletOwner
     * @ORM\Id()
     * @ORM\ManyToOne(targetEntity="IssetBV\PaymentBundle\Domain\WalletOwner")
     */
    private $walletOwner;

    /**
     * @var Wallet
     * @ORM\Id()
     * @ORM\ManyToOne(targetEntity="IssetBV\PaymentBundle\Domain\Wallet")
     */
    private $wallet;

    public function getOwner(): WalletOwner
    {
        return $this->walletOwner;
    }
}
