<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;
use IssetBV\TalosBundle\Gateway\Logger\LogData;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;

/**
 * Class GatewayLogRecord.
 *
 * @author Tim Fennis <tim@isset.nl>
 * @ORM\Entity()
 * @ORM\Table(name="talos__gateway_log_records")
 */
class GatewayLogRecord
{
    /**
     * @var UuidInterface
     * @ORM\Id()
     * @ORM\Column(name="id", type="uuid", nullable=false)
     */
    private $requestId;

    /**
     * @var UuidInterface
     * @ORM\Column(name="group_id", type="uuid", nullable=false)
     */
    private $groupId;

    /**
     * @var int
     * @ORM\Column(name="sequence_id", type="integer", nullable=false)
     */
    private $sequenceId;

    /**
     * @var string
     * @ORM\Column(name="request", type="text", nullable=false)
     */
    private $request;

    /**
     * @var DateTime
     * @ORM\Column(name="request_date", type="datetime", nullable=false)
     */
    private $requestDate;

    /**
     * @var string
     * @ORM\Column(name="response", type="text", nullable=true)
     */
    private $response;

    /**
     * @var DateTime
     * @ORM\Column(name="response_date", type="datetime", nullable=true)
     */
    private $responseDate;

    /**
     * GatewayLogRecord constructor.
     *
     * @param UuidInterface $requestId
     * @param UuidInterface $groupId
     * @param int $sequenceId
     * @param string $request
     * @param string $response
     * @param DateTime $requestDate
     * @param DateTime $responseDate
     */
    public function __construct(UuidInterface $requestId, UuidInterface $groupId, int $sequenceId, string $request, string $response, DateTime $requestDate, DateTime $responseDate)
    {
        $this->requestId = $requestId;
        $this->groupId = $groupId;
        $this->request = $request;
        $this->response = $response;
        $this->sequenceId = $sequenceId;
        $this->requestDate = $requestDate;
        $this->responseDate = $responseDate;
    }

    /**
     * @return UuidInterface
     */
    public function getRequestId(): UuidInterface
    {
        return $this->requestId;
    }

    /**
     * @return int
     */
    public function getSequenceId(): int
    {
        return $this->sequenceId;
    }

    /**
     * @return UuidInterface
     */
    public function getGroupId(): UuidInterface
    {
        return $this->groupId;
    }

    /**
     * @return DateTime
     */
    public function getRequestDate(): DateTime
    {
        return $this->requestDate;
    }

    /**
     * @return DateTime
     */
    public function getResponseDate(): DateTime
    {
        return $this->responseDate;
    }

    /**
     * @return string
     */
    public function getRequest(): string
    {
        return $this->request;
    }

    /**
     * @return string
     */
    public function getResponse(): string
    {
        return $this->response;
    }

    /**
     * @param LogData $logData
     *
     * @return GatewayLogRecord
     */
    public static function fromLogData(LogData $logData)
    {
        return new self(
            $logData->getRequestId(),
            $logData->getGroupId(),
            $logData->getSequenceId(),
            $logData->getRequest(),
            $logData->getResponse(),
            $logData->getRequestDate(),
            $logData->getResponseDate()
        );
    }
}
