<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\CommandBus\SynchronizePayment;

use IssetBV\PaymentBundle\CommandBus\SynchronizePayment\CannotSynchronizePaymentException;
use IssetBV\PaymentBundle\CommandBus\SynchronizePayment\SynchronizePaymentCommand;
use IssetBV\TalosBundle\Gateway\ApiGateway;
use IssetBV\TalosBundle\Gateway\Request\ClientData;
use IssetBV\TalosBundle\Gateway\Request\Request;
use IssetBV\TalosBundle\Gateway\Request\Service;
use IssetBV\TalosBundle\Gateway\Shared\SingleField;
use IssetBV\TalosBundle\ResponseHandler\PaymentResponseHandler;

/**
 * Class TalosSynchronizePaymentHandler.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class SynchronizePaymentHandler
{
    const ACTION_NAME = 'Status';

    /**
     * @var ApiGateway
     */
    private $gateway;

    /**
     * @var PaymentResponseHandler
     */
    private $paymentResponseHandler;

    /**
     * TalosSynchronizePaymentHandler constructor.
     *
     * @param ApiGateway $gateway
     * @param PaymentResponseHandler $paymentResponseHandler
     */
    public function __construct(ApiGateway $gateway, PaymentResponseHandler $paymentResponseHandler)
    {
        $this->gateway = $gateway;
        $this->paymentResponseHandler = $paymentResponseHandler;
    }

    /**
     * @param SynchronizePaymentCommand $command
     *
     * @throws CannotSynchronizePaymentException
     */
    public function handle(SynchronizePaymentCommand $command)
    {
        $request = new Request(ClientData::empty(), [
            new Service('General', self::ACTION_NAME, [
                new SingleField('ObjectType', 'Payment'),
//                new SingleField('ObjectIdentifier', ), //@todo this is the talos ID that we don't need to use AFAIK
                new SingleField('ObjectReference', (string) $command->getPaymentIdentifier()),
            ]),
        ]);

        $request->addResponseHandler($this->paymentResponseHandler);

        $this->gateway->send([$request]);
    }
}
