<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\SynchronizeWallet;

/**
 * Class SyncWalletCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class SynchronizeWalletCommand
{
    /**
     * @var string
     */
    protected $walletIdentifier;

    /**
     * @param string $walletIdentifier
     */
    public function __construct(string $walletIdentifier)
    {
        $this->walletIdentifier = $walletIdentifier;
    }

    /**
     * @return string
     */
    public function getWalletIdentifier(): string
    {
        return $this->walletIdentifier;
    }
}
