<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain\Repository;

use IssetBV\PaymentBundle\Domain\Mutation;
use PhpOption\Option;

/**
 * Interface MutationRepository.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface MutationRepository
{
    /**
     * @param string $mutationIdentifier hexadecimal string representation of the remote identifier of the
     *
     * @return Mutation|Option <Mutation> and optional containing the mutation
     */
    public function findWithRemoteIdentifier(string $mutationIdentifier): Option;

    /**
     * @param Mutation $mutation
     */
    public function save(Mutation $mutation);
}
