<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Logger;

use DateTime;
use Ramsey\Uuid\UuidInterface;

/**
 * Class LogData.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class LogData
{
    /**
     * @var UuidInterface
     */
    private $requestId;

    /**
     * @var UuidInterface
     */
    private $groupId;

    /**
     * @var int
     */
    private $sequenceId;

    /**
     * @var string
     */
    private $request;

    /**
     * @var string
     */
    private $response;

    /**
     * @var DateTime
     */
    private $requestDate;

    /**
     * @var DateTime
     */
    private $responseDate;

    /**
     * LogData constructor.
     *
     * @param UuidInterface $requestId
     * @param UuidInterface $groupId
     * @param int $sequenceId
     * @param string $request
     * @param string $response
     * @param DateTime $requestDate
     * @param DateTime $responseDate
     */
    public function __construct(UuidInterface $requestId, UuidInterface $groupId, int $sequenceId, string $request, string $response, DateTime $requestDate, DateTime $responseDate)
    {
        $this->requestId = $requestId;
        $this->groupId = $groupId;
        $this->sequenceId = $sequenceId;
        $this->request = $request;
        $this->response = $response;
        $this->requestDate = $requestDate;
        $this->responseDate = $responseDate;
    }

    /**
     * @return UuidInterface
     */
    public function getRequestId(): UuidInterface
    {
        return $this->requestId;
    }

    /**
     * @return UuidInterface
     */
    public function getGroupId(): UuidInterface
    {
        return $this->groupId;
    }

    /**
     * @return int
     */
    public function getSequenceId(): int
    {
        return $this->sequenceId;
    }

    /**
     * @return string
     */
    public function getRequest(): string
    {
        return $this->request;
    }

    /**
     * @return string
     */
    public function getResponse(): string
    {
        return $this->response;
    }

    /**
     * @return DateTime
     */
    public function getRequestDate(): DateTime
    {
        return $this->requestDate;
    }

    /**
     * @return DateTime
     */
    public function getResponseDate(): DateTime
    {
        return $this->responseDate;
    }
}
