<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain\Repository;

use Doctrine\Common\Collections\Selectable;
use IssetBV\PaymentBundle\Domain\PaymentIssuer;
use PhpOption\Option;

/**
 * Interface PaymentIssuerRepository.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface PaymentIssuerRepository extends Selectable
{
    /**
     * Returns a list of all the PaymentIssuers.
     *
     * @see PaymentIssuer
     *
     * @return PaymentIssuer[]
     */
    public function findAll();

    /**
     * @param string $customerAccountIssuer
     *
     * @return Option
     */
    public function findOneByCode(string $customerAccountIssuer): Option;
}
