<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use IssetBV\PaymentBundle\Domain\AutoTopupProfile;
use IssetBV\PaymentBundle\Domain\RemoteObject;
use IssetBV\TalosBundle\Storage\CreatedUpdatedFields;
use Money\Money;
use PhpOption\Option;

/**
 * Class TalosAutoTopupProfile.
 *
 * @author Tim Fennis <tim@isset.nl>
 * @ORM\Entity(repositoryClass="IssetBV\TalosBundle\Repository\DoctrineAutoTopupProfileRepository")
 * @ORM\Table(name="auto_topup_profiles")
 * @ORM\HasLifecycleCallbacks()
 */
class TalosAutoTopupProfile implements RemoteObject, AutoTopupProfile
{
    use CreatedUpdatedFields;
    /**
     * @var string
     * @ORM\Column(name="id", type="string", nullable=false)
     * @ORM\Id()
     */
    private $id;

    /**
     * @var int
     * @ORM\Column(name="cooldown", type="integer", nullable=true)
     */
    private $cooldown;

    /**
     * @var int
     * @ORM\Column(name="limit_period", type="integer", nullable=true)
     */
    private $limitPeriod;

    /**
     * @var Money
     * @ORM\Column(name="limit_amount", type="money", nullable=true)
     */
    private $limitAmount;

    /**
     * @var Money
     * @ORM\Column(name="activation_balance", type="money", nullable=true)
     */
    private $activationBalance;

    /**
     * TalosAutoTopupProfile constructor.
     *
     * @param string $id
     * @param int $cooldown
     * @param int $limitPeriod
     * @param Money $limitAmount
     * @param Money $activationBalance
     */
    public function __construct(string $id, int $cooldown = null, int $limitPeriod = null, Money $limitAmount = null, Money $activationBalance = null)
    {
        $this->initCrudFields();
        $this->id = $id;
        $this->cooldown = $cooldown;
        $this->limitPeriod = $limitPeriod;
        $this->limitAmount = $limitAmount;
        $this->activationBalance = $activationBalance;
    }

    /**
     * @return int
     */
    public function getCooldown(): int
    {
        return $this->cooldown;
    }

    /**
     * @return int
     */
    public function getLimitPeriod(): int
    {
        return $this->limitPeriod;
    }

    /**
     * @return Money
     */
    public function getLimitAmount(): Money
    {
        return $this->limitAmount;
    }

    /**
     * @return Money
     */
    public function getActivationBalance(): Money
    {
        return $this->activationBalance;
    }

    /**
     * Returns the remote identifier of this object.
     *
     * @return Option
     */
    public function getRemoteIdentifier(): Option
    {
        return Option::ensure($this->id);
    }

    /**
     * @deprecated allah?
     * @param string $remoteIdentifier
     */
    public function setRemoteIdentifier(string $remoteIdentifier)
    {
        $this->id = $remoteIdentifier;
    }

    /**
     * @param string $remoteStatusCode
     */
    public function setRemoteStatus(string $remoteStatusCode)
    {
        throw new \LogicException('Method not available');
    }

    /**
     * @return string
     */
    public function getRemoteStatus(): string
    {
        return '';
    }
}
