<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Controller;

use IssetBV\Json\SimpleDecoder;
use IssetBV\TalosBundle\Gateway\Response\Response as ApiResponse;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * Class NotificationController.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class NotificationController extends Controller
{
    /**
     * @Route(path="talos/notification")
     *
     * @param Request $request
     *
     * @return Response
     */
    public function handleNotificationAction(Request $request)
    {
        $this->logRequest($request);
        $objectManager = $this->get('doctrine.orm.entity_manager');

        $decoder = new SimpleDecoder();
        $data = $decoder->decode((string) $request->getContent());
        $response = ApiResponse::fromJsonThing($data);
        foreach ($response->getRequestObjects() as $requestObject) {
            if ($requestObject->getType() === 'Payment') {
                $paymentResponseHandler = $this->get('issetbv_talos.response_handler.payment_response_handler');
                $paymentResponseHandler->handleResponse($response);
            } elseif ($requestObject->getType() === 'Wallet') {
                $walletResponseHandler = $this->get('issetbv_talos.response_handler.wallet_response_handler');
                $walletResponseHandler->handleResponse($response);
            }
        }

        $objectManager->flush();

        return new Response('');
    }

    /**
     * @param Request $request
     */
    protected function logRequest(Request $request)
    {
        $log = 'Method: ' . $request->getMethod() . PHP_EOL;
        $log .= 'Endpoint: ' . $request->getUri() . PHP_EOL;

        $log .= PHP_EOL . 'Headers: ' . PHP_EOL . json_encode($request->headers->all(), JSON_PRETTY_PRINT) . PHP_EOL;
        $log .= PHP_EOL . 'Data: ' . PHP_EOL . json_encode($request->request->all(), JSON_PRETTY_PRINT) . PHP_EOL;

        $this->get('monolog.logger.payment')->error($log);
    }
}
