<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Factory;

use IssetBV\PaymentBundle\Domain\Invoice\Invoice;
use IssetBV\PaymentBundle\Domain\Payment;
use IssetBV\PaymentBundle\Domain\PaymentIssuer;
use IssetBV\PaymentBundle\Domain\PaymentMethod;
use Money\Money;

/**
 * Interface PaymentFactory.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface PaymentFactory
{
    /**
     * @param Invoice $invoice
     * @param Money $money
     * @param PaymentMethod $paymentMethod
     * @param PaymentIssuer $issuer
     * @param string $recurrentType
     *
     * @return Payment
     */
    public function createPayment(Invoice $invoice, Money $money, PaymentMethod $paymentMethod, PaymentIssuer $issuer = null, string $recurrentType): Payment;
}
