<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain;

/**
 * Class PaymentMethod.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface PaymentMethod
{
    /**
     * @return string
     */
    public function getDisplayName(): string;

    /**
     * Returns a list of issuers associated to this payment method. Note that some payment methods don't have issuers.
     *
     * @return PaymentIssuer[]
     */
    public function getIssuers();

    /**
     * Because in rare cases a payment method may need an issuer can't provide any for technical reasons. This method
     * should be used to check if a payment method requires an issuer.
     *
     * @return bool
     */
    public function shouldHaveIssuers(): bool;

    /**
     * @return Wallet
     */
    public function getWallet(): Wallet;
}
