<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\ExecutePayment;

use Exception;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
final class CannotExecutePaymentException extends Exception
{
    public static function becauseNoIssuerWasSet($paymentIdentifier = 'unknown'): CannotExecutePaymentException
    {
        return new self("Unable to create service request for ideal payment (id: $paymentIdentifier) because no payment issuer (bank) was set in the payment");
    }

    public static function becauseTheReturnUrlWasNotSet($paymentIdentifier = 'unknown'): CannotExecutePaymentException
    {
        return new self("Unable to execute payment (id: $paymentIdentifier) because the return URL was not set in the payment");
    }
}
