<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\ResponseHandler;

use IssetBV\TalosBundle\Gateway\Response\Handler\ResponseHandler;
use IssetBV\TalosBundle\Gateway\Response\Response;

/**
 * Class CallbackResponseHandler.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class CallbackResponseHandler implements ResponseHandler
{
    /**
     * @var callable
     */
    private $callable;

    /**
     * CallbackResponseHandler constructor.
     *
     * @param callable $callable
     */
    public function __construct(callable $callable)
    {
        $this->callable = $callable;
    }

    /**
     * @param Response $response
     */
    public function handleResponse(Response $response)
    {
        ($this->callable)($response);
    }
}
