<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Logger;

use Doctrine\Common\Persistence\ObjectManager;
use IssetBV\TalosBundle\Entity\GatewayLogRecord;
use PhpOption\Option;

/**
 * This class logs DataLog entries to a doctrine database.
 *
 * @todo problem: if an error occurs in the request the transaction is rollbacked and this entity is not peristed :(
 * @todo create a new logger that uses a raw separate connection to log
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class DoctrineLogger implements GatewayLogger
{
    /**
     * @var Option
     */
    private $objectManager;

    /**
     * DoctrineLogger constructor.
     *
     * @param ObjectManager $objectManager
     */
    public function __construct(ObjectManager $objectManager = null)
    {
        $this->objectManager = Option::ensure($objectManager);
    }

    /**
     * @param LogData $logData
     */
    public function log(LogData $logData)
    {
        $this->objectManager->forAll(function (ObjectManager $objectManager) use ($logData) {
            $record = GatewayLogRecord::fromLogData($logData);
            $objectManager->persist($record);
            $objectManager->flush();
        });
    }
}
