<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Exception;

use Exception;

/**
 * Class FileNotFoundException.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class FileNotFoundException extends ApiGatewayException
{
    /**
     * FileNotFoundException constructor.
     *
     * @param string $path
     * @param int $code
     * @param Exception $previous
     */
    public function __construct($path, $code = 0, Exception $previous = null)
    {
        parent::__construct('File not found: ' . $path, $code, $previous);
    }
}
