<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain;

/**
 * Interface WalletType.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface WalletType
{
    /**
     * @return bool
     */
    public function isCustomerWallet(): bool;

    /**
     * @return bool
     */
    public function isPaymentWallet(): bool;

    /**
     * @return bool
     */
    public function isReversiblePaymentSubWallet(): bool;

    /**
     * @return string
     */
    public function getDescription(): string;
}
