<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain\Subscription;

use Money\Money;

/**
 * This provider is used by the subscription renew mechanism. The implementation needs to provide an amount to renew
 * the subscription with.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface RenewAmountProvider
{
    /**
     * @param Subscription $subscription
     *
     * @return Money the amount that needs to be billed to renew this subscription
     */
    public function findRenewAmount(Subscription $subscription): Money;
}
