<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\SynchronizePayment;

use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;
use IssetBV\PaymentBundle\Domain\Payment;

/**
 * Class SynchronizeLocalPaymentCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class SynchronizeLocalPaymentCommand
{
    /**
     * @var LocalPaymentIdentifier
     */
    private $paymentIdentifier;

    public function __construct(LocalPaymentIdentifier $paymentIdentifier)
    {
        $this->paymentIdentifier = $paymentIdentifier;
    }

    public function getPaymentIdentifier(): LocalPaymentIdentifier
    {
        return $this->paymentIdentifier;
    }

    public static function fromPayment(Payment $payment): self
    {
        return new self($payment->getId());
    }
}
