README
======

# Structure
The original intent was to split this bundle in to two separate bundles, but they were kept in a single git repository
for convenience sake. If a new payment provider needs to be added one option would be to simply include it here.

## The Payment Bundle
The Payment bundle describes the types of actions and data that a payment provider needs to implement in order to work.
It also contains most of the logic related to subscriptions. In theory the Payment Bundle is the only thing you need to 
integrate into your application in order to use payments in your application and the implementation-bundles such as the
`TalosBundle` provide the implementation for these actions.

**PaymentBundle/Cli**
This folder contains a bunch of console commands that call generic operations that deal with payments and subscriptions.
There are more Cli commands available in the `TalosBundle/Cli` folder but those are more specific to a payment method.

**PaymentBundle/CommandBus**
The general idea of this bundle is to use a command bus for all data mutations that are needed. The PaymentBundle provides
all the commands that a payment provider needs to implement in order to function. And the application can use the commands
form the `PaymentBundle` to manage payments and subscriptions. 

_note: in practice there might be quite a few Talos specific things in these commands so implementing them for a
different payment provider may prove difficult_

_note: check the docs for the command bus package if you want to learn more about this design philosophy https://tactician.thephpleague.com/_

**PaymentBundle/Domain**
This folder contains mostly interfaces for the types of data that need to be available for the commands to operate on.
Some interfaces also have a generic implementation that the application can use without having to provide their own. 
Although most of these interfaces ought to be implemented by the payment provider, some of them are left to the application.

**PaymentBundle/<remaining folders>**
The remaining folders should be pretty easy to figure out

## The Talos Bundle
The main purpose of this bundle is to provide handlers for the commands that are specified in the `PaymentBundle`. Right
now it's up to the application that implements this bundle to specify the mapping between commands and handlers.

### Hotspots

**Class IssetBV\TalosBundle\Service\PaymentExecutor**
This is where payments are sent to be executed ;) this class builds a request and sends it to the API for processing.

# Subscriptions
The `Subscription` and `SubscriptionTerm` entities live inside the PaymentBundle. I hope the code mostly explains 
itself but there are some quirks and other interesting design decisions that I'll list below.

## Cancellation
If a subscription is ever cancelled you can only resume it by creating a new separate subscription. It's up to the
application that implements this bundle to determine if an account stays active after cancellation of the subscription
and to automatically set the begin term of the new subscription to the expiration date of the current (cancelled) 
subscription in order to not have overlapping subscriptions. The application may decide to have multiple overlapping
subscriptions.

## Denormalization
The status of a subscription is denormalized for performance reasons. There is a command and handler called
`DenormalizeSubscriptionStatusHandler` that takes care of this.

## Creating and executing new payments
This CLI command which should maybe be wrapped in a CommandBus command takes care of updating the status of subscriptions
and creating/executing new payments when needed.

\IssetBV\PaymentBundle\Cli\UpdateSubscriptionCommand

\IssetBV\PaymentBundle\CommandBus\RenewSubscription\RenewSubscriptionHandler

# 3rd party dependencies

## Money
For dealing with money amounts/values

http://moneyphp.org/en/stable/

## Tactician Command Bus
For the command bus pattern

https://tactician.thephpleague.com/

## Option PHP
Adds an optional monad to PHP

https://github.com/schmittjoh/php-option

## Functional PHP
Adds a ton of functional programming functions like (map, filter, first, last, reindex, true, some etc.)

https://github.com/lstrojny/functional-php


# @Corné
I understand you're tasked with adding a new payment provider to this draconian system. I really tried to make something
that would be reusable when the payment provider had to be changed eventually but IMO switching payment providers
ad-hoc is a myth. They all have their own quirks and abstracting/(accounting for) all of them is an almost impossible task.

Most of the code in this project is the actual implementation of the Talos API and you most likely don't have to deal
with any of that at all. There is obviously no reason to mimic that implementation in any way so I advice you to come
up with your own systems.

There are also a lot of command and interfaces related to Wallets. This system isn't actually used in getclose2 so I 
recommend you ignore it as much as possible or remove it if you really have to. The idea behind wallets is that they are
like simple bank accounts that you can top up with money and create payments out of. I can imagine that we might want
to implement this again in the future.

This bundle is currently only used the getclose2 project so you don't have to worry about BC breaks. If you want to
overhaul the entire `PaymentBundle` then be my guest!

If you have any questions please let me know and I'll try to answer them as best as I can. (@Tim Fennis) 

# Rules

Some random rules that I tried to stick to

* Commands should only contain primitive values so they can easily be serialized (or otherwise serializable entities).
This would allow us to enable async processing of commands transparently at a later stage.

* Most of the database entities related to payments are just slave copies of data that we get from an API. Updating
these means nothing.