<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Form\DataTransformer;

use Money\Money;
use Money\MoneyFormatter;
use Money\MoneyParser;
use Symfony\Component\Form\DataTransformerInterface;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class MoneyTransformer implements DataTransformerInterface
{
    /**
     * @var null|string
     */
    private $forceCurrency;

    /**
     * @var MoneyFormatter
     */
    private $moneyFormatter;

    /**
     * @var MoneyParser
     */
    private $moneyParser;

    /**
     * MoneyTransformer constructor.
     *
     * @param MoneyFormatter $moneyFormatter
     * @param MoneyParser $moneyParser
     * @param string|null $forceCurrency
     */
    public function __construct(MoneyFormatter $moneyFormatter, MoneyParser $moneyParser, $forceCurrency)
    {
        $this->moneyFormatter = $moneyFormatter;
        $this->moneyParser = $moneyParser;
        $this->forceCurrency = $forceCurrency;
    }

    public function transform($value)
    {
        return $value instanceof Money ? $this->moneyFormatter->format($value) : $value;
    }

    public function reverseTransform($value)
    {
        return $this->moneyParser->parse($value, $this->forceCurrency);
    }
}
