<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\DenormalizeSubscriptionStatus;

use Exception;
use IssetBV\PaymentBundle\Domain\Subscription\SubscriptionIdentifier;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class CannotDenormalizeSubscriptionStatusException extends Exception
{
    public static function becauseTheSubscriptionCouldNotBeFound(SubscriptionIdentifier $identifier): CannotDenormalizeSubscriptionStatusException
    {
        return new self('Cannot denormalize subscription because the subscription with identifier ' . $identifier->asString() . ' could not be found');
    }
}
