<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Repository;

use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\Criteria;
use Doctrine\ORM\EntityRepository;
use IssetBV\PaymentBundle\Domain\Repository\WalletOwnerRepository;
use PhpOption\Option;

/**
 * Class WalletOwnerRepository.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class DoctrineWalletOwnerRepository extends EntityRepository implements WalletOwnerRepository
{
    /**
     * Selects all elements from a selectable that match the expression and
     * returns a new collection containing these elements.
     *
     * @param Criteria $criteria
     *
     * @return Collection
     */
    public function matching(Criteria $criteria)
    {
        return $this->matching($criteria);
    }

    /**
     * Returns an option baring the wallet owner if the wallet owner exists.
     *
     * @param mixed $identifier
     *
     * @return Option<WalletOwner>
     */
    public function optionallyFind($identifier): Option
    {
        return Option::ensure($this->find($identifier));
    }
}
